	'                       C V B a s i c   G o r i l l a s
	'
	'                      by Oscar Toledo G. (nanochess.org)
	'                    Original game (c) Microsoft Corp 1990
	'
	' Your mission is to hit your opponent with the exploding banana
	' by varying the angle and power of your throw, taking into account
	' wind speed, gravity, and the city skyline.
	'
	' Creation date: Aug/08/2024.
	' Revision date: Aug/09/2024. Port completed.
	'
	'

	' Constants
	CONST ScrWidth = 256
	CONST ScrHeight = 192
	CONST GHeight = 6

	CONST ScaleGame = 10
	CONST Power = 32

	' Global Variables
	DIM BCoor(32 * 2)
	DIM GorillaX(2)
	DIM GorillaY(2)
	DIM TotalWins(2)

	SIGNED Wind
	SIGNED #InitXVel, #InitYVel, #x, #y, #w, #v

	FOR c = 0 TO 30
		WAIT
	NEXT c

	PLAY FULL
	
restart:
	GOSUB InitVars

	GOSUB Intro

	GOSUB GetInputs

	GOSUB GorillaIntro

	GOSUB PlayGame
	
	GOTO restart

InitVars:	PROCEDURE
	END

	' DoShot:
	'   Controls banana shots by accepting player input and plotting
	'   shot angle.
	' Parameters:
	'   PlayerNum - Player
	'
DoShot:	PROCEDURE

	' Input shot
	IF PlayerNum = 0 THEN
		LocateCol = 4
	ELSE
		LocateCol = 25
	END IF

	PRINT AT LocateCol,"Angle"

	GOSUB GetNum
	#Angle = #c

	' Erase input
	PRINT AT LocateCol,"     "
	PRINT AT LocateCol+32,"     "

	PRINT AT LocateCol,"Speed"

	GOSUB GetNum
	#Velocity = #c

	' Erase input
	PRINT AT LocateCol,"     "
	PRINT AT LocateCol+32,"     "

	IF PlayerNum = 1 THEN
		#Angle = 180 - #Angle
	END IF

	GOSUB PlotShot

	IF PlayerHit = 255 THEN
	ELSE
		i = PlayerHit XOR 1
		GOSUB VictoryDance
		hit = 1
	END IF

	END

	' DoSun:
	'   Draws the sun at the top of the screen.
	' Parameters:
	'   Mouth - If non-zero draws "O" mouth else draws a smile mouth.
	'   
DoSun:	PROCEDURE
	IF Mouth = 0 THEN	' Smile mouth
		SPRITE 1,8,120,0,10
	ELSE
		SPRITE 1,8,120,4,10
	END IF
	END

	' GetInputs:
	'   Gets user inputs at beginning of game
	'
GetInputs:	PROCEDURE
	CLS
	
	PRINT AT 34,"Play to how many total points"
	PRINT AT 66,"(Default = 3) ?"

	PlayerNum = 255
	LocateCol = 66
	GOSUB GetNum
	NumGames = #c
	IF NumGames = 0 THEN NumGames = 3

	PRINT AT 194,"Gravity in Mts/Sec multiplied"
	PRINT AT 226,"by 10 (Earth = 98) ?"
	LocateCol = 226
	GOSUB GetNum
	IF #c > 255 THEN #c = 255
	#Gravity = #c
	IF #Gravity = 0 THEN #Gravity = 98

	END

	' GetNum:
	'   Gets valid numeric input from user
	'
GetNum:	PROCEDURE
	#c = 0
	#cursor_pos = LocateCol + 32
	WHILE 1
		PRINT AT #cursor_pos,"#"

		GOSUB get_key

		PRINT AT #cursor_pos," "

		IF key = 10 THEN
			IF #cursor_pos > LocateCol + 32 THEN #cursor_pos = #cursor_pos - 1
			#c = #c / 10
		ELSEIF key = 11 THEN
			RETURN
		ELSEIF #c * 10 <= 999 THEN
			PRINT AT #cursor_pos,<>key
			#cursor_pos = #cursor_pos + 1
			#c = #c * 10 + key
		END IF
	WEND

	END

	' GorillaIntro:
	'   Displays gorillas on screen for the first time.
	'
GorillaIntro:	PROCEDURE
	PRINT AT 521,"--------------"
	PRINT AT 585,"1 - View Intro"
	PRINT AT 617,"2 - Play Game"
	PRINT AT 681," Your Choice?"

	PlayerNum = 255
	GOSUB get_key
	
	CLS
	FOR c = 0 TO 31
		SPRITE c, $d1, 0, 0, 0
	NEXT c
	FOR #c = $2100 TO $23FF
		VPOKE #c, $f4
		VPOKE #c + $0800, $f4
		VPOKE #c + $1000, $f4
	NEXT #c
	BORDER 1
	DEFINE SPRITE 0,5,game_sprites_0
	DEFINE SPRITE 16,14,game_sprites_1
	DEFINE CHAR 128,9,game_bitmaps
	DEFINE COLOR 128,9,game_colors

	IF key = 1 THEN
		GOSUB clear_screen

		PLAY music_intro

		PRINT AT 40,"CVBASIC GORILLAS"
		PRINT AT 108,"STARRING:"

		SPRITE 2, 96, 96, 4 * 4, 10
		SPRITE 3, 96, 144, 4 * 4, 10
		FOR d = 1 TO 120
			WAIT
		NEXT d

		FOR c = 1 TO 2
			SPRITE 2, 96, 96, 2 * 4, 10
			SPRITE 3, 96, 144, 3 * 4, 10
			FOR d = 1 TO 80
				WAIT
			NEXT d

			SPRITE 2, 96, 96, 3 * 4, 10
			SPRITE 3, 96, 144, 2 * 4, 10
			FOR d = 1 TO 80
				WAIT
			NEXT d
		NEXT c

		WHILE music.playing: WAIT: WEND

		FOR c = 1 TO 4
			SPRITE 2, 96, 96, 2 * 4, 10
			SPRITE 3, 96, 144, 3 * 4, 10
			PLAY music_shot_explosion
			FOR d = 1 TO 20
				WAIT
			NEXT d

			SPRITE 2, 96, 96, 3 * 4, 10
			SPRITE 3, 96, 144, 2 * 4, 10
			PLAY music_shot_explosion
			FOR d = 1 TO 20
				WAIT
			NEXT d
		NEXT c

	END IF

	END

	' Intro:
	'   Displays game introduction
	'
Intro:	PROCEDURE
	MODE 0
	BORDER 1

	WAIT

	DEFINE CHAR 252,3,asterisk_bitmaps_1
	DEFINE COLOR 252,3,asterisk_colors

asterisk_bitmaps_1:
	DATA BYTE $00,$6C,$38,$FE,$38,$6C,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00

asterisk_bitmaps_2:
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$6C,$38,$FE,$38,$6C,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00

asterisk_bitmaps_3:
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$6C,$38,$FE,$38,$6C,$00,$00

asterisk_colors:
	DATA BYTE $60,$60,$60,$60,$60,$60,$60,$60
	DATA BYTE $60,$60,$60,$60,$60,$60,$60,$60
	DATA BYTE $60,$60,$60,$60,$60,$60,$60,$60

	d = 252
	FOR #c = $1800 TO $181F
		VPOKE #c, d
		d = d + 1
		IF d = 255 THEN d = 252
	NEXT #c
	FOR #c = $183f TO $1a7f STEP $20
		VPOKE #c, d
		d = d + 1
		IF d = 255 THEN d = 252
	NEXT #c
	FOR #c = $1a9f TO $1a80 STEP -1
		VPOKE #c, d
		d = d + 1
		IF d = 255 THEN d = 252
	NEXT #c
	FOR #c = $1a60 TO $1820 STEP -32
		VPOKE #c, d
		d = d + 1
		IF d = 255 THEN d = 252
	NEXT #c
	PRINT AT 40,"CVBasic GORILLAS"

	PRINT AT 72,"Port by nanochess"
	
	PLAY music_title

	'             01234567890123456789
	PRINT AT 130,"Your mission is to hit your"
	PRINT AT 162,"opponent with the exploding"
	PRINT AT 194,"banana by varying the angle"
	PRINT AT 226,"and power of your throw."

	PRINT AT 290,"You should take in account"
	PRINT AT 322,"wind speed, gravity and the"
	PRINT AT 354,"city skyline."

	PRINT AT 418,"The wind speed is shown by a"
	PRINT AT 450,"directional arrow at the"
	PRINT AT 482,"bottom of the playing field,"
	PRINT AT 514,"its length relative to"
	PRINT AT 546,"its strength."

	PRINT AT 707,"Press any key to continue"

	d = 0
	debounce = 15
	DO
		WAIT
		IF (FRAME AND 3) = 0 THEN
			d = d + 1
			IF d = 3 THEN d = 0
			IF d = 0 THEN DEFINE CHAR 252,3,asterisk_bitmaps_1
			IF d = 1 THEN DEFINE CHAR 252,3,asterisk_bitmaps_2
			IF d = 2 THEN DEFINE CHAR 252,3,asterisk_bitmaps_3
		END IF
		IF debounce THEN debounce = debounce - 1
		key = cont.key
	LOOP WHILE debounce <> 0 OR key = 15

	END

	' MakeCityScape:
	'   Creates random skyline for game
	'
MakeCityScape:	PROCEDURE

	' Set the sloping trend of the city scape. NewHt is new building height
	Slope = RANDOM(6) + 1

	IF Slope = 1 THEN
		NewHt = 4	' Upward slope
	ELSEIF Slope = 2 THEN
		NewHt = 18	' Downward slope
	ELSEIF Slope = 6 THEN
		NewHt = 18	' Inverted "V" slope
	ELSE
		NewHt = 4	' "V" slope - most common
	END IF

	HtInc = 1	' Increase value for new height
	x = 0
	CurBuilding = 0
	DO
		IF Slope = 1 THEN
			NewHt = NewHt + HtInc
		ELSEIF Slope = 2 THEN
			NewHt = NewHt - HtInc
		ELSEIF Slope = 6 THEN	' It is 4 in original (bug)
			IF x > 16 THEN
				NewHt = NewHt + HtInc
			ELSE
				NewHt = NewHt - HtInc
			END IF
		ELSE
			IF x > 16 THEN
				NewHt = NewHt - HtInc
			ELSE
				NewHt = NewHt + HtInc
			END IF
		END IF

		' Set width of building and check to see if it would go off the screen
		BWidth = RANDOM(3) + 2
		IF x + BWidth > 32 THEN BWidth = 32 - x

		' Set height of building and check to see if it goes below screen
		BHeight = RANDOM(3) + NewHt
		IF BHeight < HtInc THEN BHeight = HtInc

		' Check to see if the building is too high
		IF 23 - BHeight <= 1 THEN BHeight = 2

		c = RANDOM(3)
		IF c = 0 THEN character = 128
		IF c = 1 THEN character = 130
		IF c = 2 THEN character = 132

		BCoor(CurBuilding * 2 + 0) = x
		BCoor(CurBuilding * 2 + 1) = 23 - BHeight

		' Draw the building
		FOR c = x TO x + BWidth - 1
			FOR d = 23 TO 23 - BHeight STEP - 1
				IF RANDOM(2) THEN
					VPOKE $1800 + d * 32 + c, character
				ELSE 
					VPOKE $1800 + d * 32 + c, character + 1
				END IF
			NEXT d
		NEXT c

		x = x + BWidth

		CurBuilding = CurBuilding + 1

	LOOP UNTIL x >= 32

	LastBuilding = CurBuilding - 1

	' Set Wind speed
	Wind = RANDOM(10) - 5
	IF RANDOM(3) = 1 THEN
		IF Wind > 0 THEN
			Wind = Wind + RANDOM(10)
		ELSE
			Wind = Wind - RANDOM(10)
		END IF
	END IF

	' Draw Wind speed arrow
	IF Wind <> 0 THEN
		#c = 720
		IF Wind < 0 THEN d = -1: e = -Wind / 2 ELSE d = 1: e = Wind / 2
		WHILE e
			VPOKE $1800 + #c, $86
			IF d = 1 THEN #c = #c + 1 ELSE #c = #c - 1
			e = e - 1
		WEND
		IF Wind < 0 THEN
			VPOKE $1800 + #c, $87
		ELSE
			VPOKE $1800 + #c, $88
		END IF
	END IF

	END

	' PlaceGorillas:
	'   Puts the Gorillas on top of the buildings.
	'
PlaceGorillas:	PROCEDURE
	' Place gorillas on second or third building from edge
	FOR i = 0 TO 1
		IF i = 0 THEN 
			BNum = RANDOM(2) + 1
		ELSE
			BNum = LastBuilding - (RANDOM(2) + 1)
		END IF

		BWidth = BCoor((BNum + 1) * 2 + 0) - BCoor(BNum * 2 + 0)

		GorillaX(i) = BCoor(BNum * 2 + 0) * 8 + BWidth * 8 / 2 - 8
		GorillaY(i) = BCoor(BNum * 2 + 1) * 8 - 16

		' Draw gorilla with arms down
		SPRITE 2 + i, GorillaY(i) - 1, GorillaX(i), 4 * 4, 10
	NEXT i

	END

	' PlayGame:
	'   Main game play routine
	'
PlayGame:	PROCEDURE
	CurrentPlayer = 1

	FOR game = 1 TO NumGames

		GOSUB clear_screen
		GOSUB MakeCityScape
		GOSUB PlaceGorillas
		Mouth = 0
		GOSUB DoSun

		hit = 0
		WHILE hit = 0
			CurrentPlayer = 1 - CurrentPlayer

			IF TotalWins(0) < 10 THEN
				PRINT AT 684
			ELSE
				PRINT AT 683
			END IF
			PRINT <>TotalWins(0), ">SCORE<", <>TotalWins(1)

			PlayerNum = CurrentPlayer

			' Plot the shot.  Hit is non-zero if Gorilla gets hit.
			GOSUB DoShot

			' Reset the sun, if it got hit
			Mouth = 0: GOSUB DoSun

			IF Hit <> 0 THEN GOSUB UpdateScores
		WEND
		FOR c = 0 TO 60
			WAIT
		NEXT c
	NEXT game

	PRINT AT 43,"GAME  OVER"
	IF TotalWins(0) < 10 THEN
		PRINT AT 684
	ELSE
		PRINT AT 683
	END IF
	PRINT <>TotalWins(0), ">SCORE<", <>TotalWins(1)

	GOSUB get_key

	END

	' PlotShot:
	'   Plots banana shot across the screen
	' Parameters:
	'   #Angle - shot angle
	'   #Velocity - shot velocity
	'   PlayerNum - the banana thrower
	'
PlotShot:	PROCEDURE
	StartX = GorillaX(PlayerNum)
	StartY = GorillaY(PlayerNum)

	StartXPos = StartX
	StartYPos = StartY - 3
	IF PlayerNum = 1 THEN
		StartXPos = StartX + 8
	END IF

	WHILE #Angle >= 360
		#Angle = #Angle - 360
	WEND

	#Angle = #Angle * 72 / 360

	#InitXVel = #cos(#Angle) * #Velocity
	IF #InitXVel < 0 THEN
		#InitXVel = -(-#InitXVel / ScaleGame)
	ELSE
		#InitXVel = #InitXVel / ScaleGame
	END IF
	#InitYVel = #sin(#Angle) * #Velocity
	IF #InitYVel < 0 THEN
		#InitYVel = -(-#InitYVel / ScaleGame)
	ELSE
		#InitYVel = #InitYVel / ScaleGame
	END IF

	' Draw gorilla toss
	IF PlayerNum = 0 THEN
		SPRITE 2, StartY - 1, StartX, 2 * 4, 10
	ELSE
		SPRITE 3, StartY - 1, StartX, 3 * 4, 10
	END IF

	' Throw sound
	PLAY music_throw

	FOR c = 1 TO 6
		WAIT
	NEXT c

	IF PlayerNum = 0 THEN
		SPRITE 2, StartY - 1, StartX, 4 * 4, 10
	ELSE
		SPRITE 3, StartY - 1, StartX, 4 * 4, 10
	END IF

	Impact = 0
	OnScreen = 1
	PlayerHit = 255
	#v = 0

	#x = StartXPos * 64
	#y = StartYPos * 64
	
	IF Wind < 0 THEN
		#v = -(-Wind / 2)
	ELSE
		#v = Wind / 2
	END IF
	#v = #v * #v / (4 * ScaleGame)

	#u = #gravity / 2
	#u = #u * #u * 2 / (3 * ScaleGame)

	#w = #v
	#z = #u

	WHILE Impact = 0 AND OnScreen = 1

		IF #y < 0 THEN
			SPRITE 0, $d1, 0, 0, 0
		ELSE
			SPRITE 0, #y / 64 - 4, #x / 64 - 4, (((FRAME / 2) AND 3) + 16) * 4, 10
		END IF

		WAIT
		WAIT
		IF #x >= 0 AND #y >= 0 AND #x < 256 * 64 AND #y < 192 * 64 THEN
			c = VPEEK(#x / 64 / 8 + #y / 64 / 8 * 32 + $1800)
			IF c <> 32 THEN
				Impact = 1
				EXIT WHILE
			END IF
		END IF
		IF ABS(#x / 64 - (GorillaX(0) + 8)) < 8 AND ABS(#y / 64 - (GorillaY(0) + 8)) < 8 THEN
			PlayerHit = 0
			Impact = 1
			#x = (GorillaX(0) + 8) * 64
			#y = (GorillaY(0) + 4) * 64			
			EXIT WHILE
		END IF
		IF ABS(#x / 64 - (GorillaX(1) + 8)) < 8 AND ABS(#y / 64 - (GorillaY(1) + 8)) < 8 THEN
			PlayerHit = 1
			Impact = 1
			#x = (GorillaX(1) + 8) * 64
			#y = (GorillaY(1) + 4) * 64			
			EXIT WHILE
		END IF
		IF ABS(#x / 64 - 128) < 8 AND ABS(#y / 64 - 16) < 8 THEN
			Mouth = 1
		ELSE
			Mouth = 0
		END IF
		GOSUB DoSun

		#x = #x + #InitXVel + #w
		#y = #y - #InitYVel + #z
		IF #x < 8 * 64 OR #x >= 252 * 64 OR #y >= 188 * 64 THEN
			OnScreen = 0
		END IF

		IF #w < 0 THEN
			#w = #w - -#w / Power
		ELSE
			#w = #w + #w / Power
		END IF
		#z = #z + #z / Power
	WEND

	IF PlayerHit = 255 AND Impact <> 0 THEN
		PLAY music_shot_explosion
		VPOKE $1800 + #x / 64 / 8 + #y / 64 / 8 * 32, 32
		FOR c = 28 TO 20 STEP -1
			SPRITE 0, #y / 64 - 8, #x / 64 - 8, c * 4, 15
			WAIT
			WAIT
		NEXT c
	ELSEIF Impact <> 0 THEN
		PLAY music_gorilla_explosion
		FOR c = 20 TO 28
			SPRITE 0, #y / 64 - 8, #x / 64 - 8, c * 4, 15
			WAIT
			WAIT
			WAIT
			WAIT
		NEXT c
		FOR c = 0 TO 10
			WAIT
		NEXT c
		IF PlayerHit = 0 THEN
			SPRITE 2, $d1, 0, 0, 0	
		END IF
		IF PlayerHit = 1 THEN
			SPRITE 3, $d1, 0, 0, 0	
		END IF
		FOR c = 28 TO 20 STEP -1
			SPRITE 0, #y / 64 - 8, #x / 64 - 8, c * 4, 15
			WAIT
			WAIT
			WAIT
			WAIT
		NEXT c
	END IF

	SPRITE 0, $d1, 0, 0, 0

	END

	' UpdateScores:
	'   Update player's scores
	'
UpdateScores:	PROCEDURE
	TotalWins(PlayerHit XOR 1) = TotalWins(PlayerHit XOR 1) + 1
	END

	' VictoryDance:
	'   gorilla dances after he has eliminated his opponent
	'
VictoryDance:	PROCEDURE
	FOR c = 1 TO 4
		PLAY music_shot_explosion
		SPRITE 2 + i, GorillaY(i) - 1, GorillaX(i), 2 * 4, 10
		
		FOR d = 1 TO 12
			WAIT
		NEXT d

		PLAY music_shot_explosion
		SPRITE 2 + i, GorillaY(i) - 1, GorillaX(i), 3 * 4, 10

		FOR d = 1 TO 12
			WAIT
		NEXT d
	NEXT c

	END

clear_screen:	PROCEDURE
	CLS
	FOR c = 0 TO 31
		SPRITE c, $D1, 0, 0, 0
	NEXT c
	END

get_key:	PROCEDURE
	debounce = 15
	DO
		WAIT
		IF debounce THEN debounce = debounce - 1
'		IF PlayerNum = 0 THEN
'			key = cont1.key
'		ELSEIF PlayerNum = 1 THEN
'			key = cont2.key
'		ELSE
			key = cont.key
'		END IF
	LOOP WHILE debounce <> 0 OR key = 15
	key = cont.key
	END

game_sprites_0:
	BITMAP "....X..X...X...."	' 0
	BITMAP "..X..X.X..X..X.."
	BITMAP "...X.X.X..X.X..."
	BITMAP "...X.X.XX.X.X..."
	BITMAP ".X..X.XXXX.X..X."
	BITMAP "..XX.XXXXXX.XX.."
	BITMAP "....XX.XX.XX...."
	BITMAP "XXXXXXXXXXXXXXXX"
	BITMAP "....X.XXXX.X...."
	BITMAP "....XX....XX...."
	BITMAP "..XX.XXXXXX.XX.."
	BITMAP ".X..X.XXXX.X..X."
	BITMAP "...X.X.XX.X.X..."
	BITMAP "...X.X.X..X.X..."
	BITMAP "..X..X.X..X..X.."
	BITMAP "....X..X...X...."

	BITMAP "....X..X...X...."	' 1
	BITMAP "..X..X.X..X..X.."
	BITMAP "...X.X.X..X.X..."
	BITMAP "...X.X.XX.X.X..."
	BITMAP ".X..X.XXXX.X..X."
	BITMAP "..XX.XXXXXX.XX.."
	BITMAP "....XX.XX.XX...."
	BITMAP "XXXXXXXXXXXXXXXX"
	BITMAP "....XXX..XXX...."
	BITMAP "....XXX..XXX...."
	BITMAP "..XX.XXXXXX.XX.."
	BITMAP ".X..X.XXXX.X..X."
	BITMAP "...X.X.XX.X.X..."
	BITMAP "...X.X.X..X.X..."
	BITMAP "..X..X.X..X..X.."
	BITMAP "....X..X...X...."

	BITMAP "...XX.XXXX......"	' 2
	BITMAP "..XX.X....X....."
	BITMAP ".XX..XXXXXX....."
	BITMAP ".XX..XX.X.X....."
	BITMAP ".XX..XXXXXX....."
	BITMAP "..XX..XXXX......"
	BITMAP "...XXXXXXXXXX..."
	BITMAP "....XXXX.XXXXX.."
	BITMAP "....XXXX.XXXXX.."
	BITMAP "....X...X...XX.."
	BITMAP ".....XXXXXX.XX.."
	BITMAP ".....XXXXXXXX..."
	BITMAP ".....XX..XX....."
	BITMAP "....XX....XX...."
	BITMAP "....XX....XX...."
	BITMAP ".....XX..XX....."

	BITMAP "......XXXX.XX..."	' 3
	BITMAP ".....X....X.XX.."
	BITMAP ".....XXXXXX..XX."
	BITMAP ".....X.X.XX..XX."
	BITMAP ".....XXXXXX..XX."
	BITMAP "......XXXX..XX.."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "..XXXXX.XXXX...."
	BITMAP "..XXXXX.XXXX...."
	BITMAP "..XX...X...X...."
	BITMAP "..XX.XXXXXX....."
	BITMAP "...XXXXXXXX....."
	BITMAP ".....XX..XX....."
	BITMAP "....XX....XX...."
	BITMAP "....XX....XX...."
	BITMAP ".....XX..XX....."

	BITMAP "......XXXX......"	' 4
	BITMAP ".....X....X....."
	BITMAP ".....XXXXXX....."
	BITMAP ".....XX.X.X....."
	BITMAP ".....XXXXXX....."
	BITMAP "......XXXX......"
	BITMAP "...XXXXXXXXXX..."
	BITMAP "..XX.XXX.XXXXX.."
	BITMAP "..XX.XXX.XXXXX.."
	BITMAP "..XX....X...XX.."
	BITMAP "...XXXXXXXX.XX.."
	BITMAP ".....XXXXXXXX..."
	BITMAP ".....XX..XX....."
	BITMAP "....XX....XX...."
	BITMAP "....XX....XX...."
	BITMAP ".....XX..XX....."

game_bitmaps:
	BITMAP "........"
	BITMAP "........"
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"
	BITMAP "........"
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"
	BITMAP "........"
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"
	BITMAP "........"
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"
	BITMAP "........"
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"
	BITMAP "........"
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"	
	BITMAP "........"
	BITMAP "........"
	BITMAP "XXXXXXXX"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"	
	BITMAP "..XX...."
	BITMAP ".XX....."
	BITMAP "XXXXXXXX"
	BITMAP ".XX....."
	BITMAP "..XX...."
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"	
	BITMAP "....XX.."
	BITMAP ".....XX."
	BITMAP "XXXXXXXX"
	BITMAP ".....XX."
	BITMAP "....XX.."
	BITMAP "........"
	BITMAP "........"

game_colors:
	DATA BYTE $1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E
	DATA BYTE $AE,$AE,$AE,$AE,$AE,$AE,$AE,$AE
	DATA BYTE $16,$16,$16,$16,$16,$16,$16,$16
	DATA BYTE $A6,$A6,$A6,$A6,$A6,$A6,$A6,$A6
	DATA BYTE $17,$17,$17,$17,$17,$17,$17,$17
	DATA BYTE $A7,$A7,$A7,$A7,$A7,$A7,$A7,$A7
	DATA BYTE $F4,$F4,$F4,$F4,$F4,$F4,$F4,$F4
	DATA BYTE $F4,$F4,$F4,$F4,$F4,$F4,$F4,$F4
	DATA BYTE $F4,$F4,$F4,$F4,$F4,$F4,$F4,$F4

game_sprites_1:
	BITMAP "................"	
	BITMAP "................"
	BITMAP "....XX.........."
	BITMAP "...XX..........."
	BITMAP "...XX..........."
	BITMAP "....XX.........."
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"

	BITMAP "................"	
	BITMAP "................"
	BITMAP "..X..X.........."
	BITMAP "..XXXX.........."
	BITMAP "...XX..........."
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"

	BITMAP "................"	
	BITMAP "................"
	BITMAP "..XX............"
	BITMAP "...XX..........."
	BITMAP "...XX..........."
	BITMAP "..XX............"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"

	BITMAP "................"	
	BITMAP "................"
	BITMAP "...XX..........."
	BITMAP "..XXXX.........."
	BITMAP "..X..X.........."
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"

	BITMAP "................"	
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP ".......XX......."
	BITMAP ".......XX......."
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"

	BITMAP "................"	
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP ".......XX......."
	BITMAP "......XXXX......"
	BITMAP "......XXXX......"
	BITMAP ".......XX......."
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"

	BITMAP "................"	
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP ".......XX......."
	BITMAP "......XXXX......"
	BITMAP ".....XXXXXX....."
	BITMAP ".....XXXXXX....."
	BITMAP "......XXXX......"
	BITMAP ".......XX......."
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"

	BITMAP "................"	
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP ".......XX......."
	BITMAP "......XXXX......"
	BITMAP ".....XXXXXX....."
	BITMAP "....XXXXXXXX...."
	BITMAP "....XXXXXXXX...."
	BITMAP ".....XXXXXX....."
	BITMAP "......XXXX......"
	BITMAP ".......XX......."
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"

	BITMAP "................"	
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "......XXXX......"
	BITMAP ".....XXXXXX....."
	BITMAP "....XXXXXXXX...."
	BITMAP "....XXXXXXXX...."
	BITMAP "....XXXXXXXX...."
	BITMAP "....XXXXXXXX...."
	BITMAP ".....XXXXXX....."
	BITMAP "......XXXX......"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"

	BITMAP "................"	
	BITMAP "................"
	BITMAP "................"
	BITMAP "......XXXX......"
	BITMAP ".....XXXXXX....."
	BITMAP "....XXXXXXXX...."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "....XXXXXXXX...."
	BITMAP ".....XXXXXX....."
	BITMAP "......XXXX......"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"

	BITMAP "................"	
	BITMAP "................"
	BITMAP "......XXXX......"
	BITMAP "....XXXXXXXX...."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "..XXXXXXXXXXXX.."
	BITMAP "..XXXXXXXXXXXX.."
	BITMAP "..XXXXXXXXXXXX.."
	BITMAP "..XXXXXXXXXXXX.."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "....XXXXXXXX...."
	BITMAP "......XXXX......"
	BITMAP "................"
	BITMAP "................"

	BITMAP "................"	
	BITMAP "......XXXX......"
	BITMAP "....XXXXXXXX...."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "..XXXXXXXXXXXX.."
	BITMAP "..XXXXXXXXXXXX.."
	BITMAP ".XXXXXXXXXXXXXX."
	BITMAP ".XXXXXXXXXXXXXX."
	BITMAP ".XXXXXXXXXXXXXX."
	BITMAP ".XXXXXXXXXXXXXX."
	BITMAP "..XXXXXXXXXXXX.."
	BITMAP "..XXXXXXXXXXXX.."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "....XXXXXXXX...."
	BITMAP "......XXXX......"
	BITMAP "................"

	BITMAP ".....XXXXXX....."	
	BITMAP "...XXXXXXXXXX..."
	BITMAP "..XXXXXXXXXXXX.."
	BITMAP ".XXXXXXXXXXXXXX."
	BITMAP ".XXXXXXXXXXXXXX."
	BITMAP "XXXXXXXXXXXXXXXX"
	BITMAP "XXXXXXXXXXXXXXXX"
	BITMAP "XXXXXXXXXXXXXXXX"
	BITMAP "XXXXXXXXXXXXXXXX"
	BITMAP "XXXXXXXXXXXXXXXX"
	BITMAP "XXXXXXXXXXXXXXXX"
	BITMAP ".XXXXXXXXXXXXXX."
	BITMAP ".XXXXXXXXXXXXXX."
	BITMAP "..XXXXXXXXXXXX.."
	BITMAP "...XXXXXXXXXX..."
	BITMAP ".....XXXXXX....."


#sin:
	DATA 0
	DATA 6
	DATA 11
	DATA 17
	DATA 22
	DATA 27
	DATA 32
	DATA 37
	DATA 41
	DATA 45
	DATA 49
	DATA 52
	DATA 55
	DATA 58
	DATA 60
	DATA 62
	DATA 63
	DATA 63
	DATA 63
	DATA 63
	DATA 63
	DATA 62
	DATA 60
	DATA 58
	DATA 55
	DATA 52
	DATA 49
	DATA 45
	DATA 41
	DATA 37
	DATA 32
	DATA 27
	DATA 22
	DATA 17
	DATA 11
	DATA 6
	DATA 0
	DATA -5
	DATA -10
	DATA -16
	DATA -21
	DATA -26
	DATA -31
	DATA -36
	DATA -40
	DATA -44
	DATA -48
	DATA -51
	DATA -54
	DATA -57
	DATA -59
	DATA -61
	DATA -62
	DATA -63
	DATA -63
	DATA -63
	DATA -62
	DATA -61
	DATA -59
	DATA -57
	DATA -54
	DATA -51
	DATA -48
	DATA -44
	DATA -40
	DATA -36
	DATA -31
	DATA -26
	DATA -21
	DATA -16
	DATA -10
	DATA -5

#cos:
	DATA 63
	DATA 63
	DATA 63
	DATA 62
	DATA 60
	DATA 58
	DATA 55
	DATA 52
	DATA 49
	DATA 45
	DATA 41
	DATA 37
	DATA 32
	DATA 27
	DATA 22
	DATA 17
	DATA 11
	DATA 6
	DATA 0
	DATA -5
	DATA -10
	DATA -16
	DATA -21
	DATA -26
	DATA -31
	DATA -36
	DATA -40
	DATA -44
	DATA -48
	DATA -51
	DATA -54
	DATA -57
	DATA -59
	DATA -61
	DATA -62
	DATA -63
	DATA -63
	DATA -63
	DATA -62
	DATA -61
	DATA -59
	DATA -57
	DATA -54
	DATA -51
	DATA -48
	DATA -44
	DATA -40
	DATA -36
	DATA -31
	DATA -26
	DATA -21
	DATA -16
	DATA -10
	DATA -5
	DATA 0
	DATA 6
	DATA 11
	DATA 17
	DATA 22
	DATA 27
	DATA 32
	DATA 37
	DATA 41
	DATA 45
	DATA 49
	DATA 52
	DATA 55
	DATA 58
	DATA 60
	DATA 62
	DATA 63
	DATA 63

music_shot_explosion:
	DATA BYTE 3
	MUSIC E4Z,-,-
	MUSIC F4Z,-,-
	MUSIC G4Z,-,-
	MUSIC E4Z,-,-
	MUSIC F4Z,-,-
	MUSIC D4Z,-,-
	MUSIC C4Z,-,-
	MUSIC STOP

music_gorilla_explosion:
	DATA BYTE 7
	MUSIC E4Z,-,-
	MUSIC F4Z,-,-
	MUSIC G4Z,-,-
	MUSIC E4Z,-,-
	MUSIC F4Z,-,-
	MUSIC D4Z,-,-
	MUSIC C4Z,-,-
	MUSIC STOP

music_intro:
	DATA BYTE 7
	MUSIC B2W,-,-
	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
	MUSIC B2,-,-
	MUSIC A2,-,-
	MUSIC A2,-,-
	MUSIC -,-,-
	MUSIC B2,-,-
	MUSIC -,-,-
	MUSIC B2,-,-
	MUSIC -,-,-
	MUSIC B2,-,-
	MUSIC A2,-,-
	MUSIC A2,-,-
	MUSIC A2,-,-
	MUSIC -,-,-
	MUSIC B2,-,-
	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
	MUSIC B2,-,-
	MUSIC A2,-,-
	MUSIC A2,-,-
	MUSIC -,-,-
	MUSIC B2,-,-
	
	MUSIC D3#,-,-
	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
	MUSIC D3#,-,-
	MUSIC C3#,-,-
	MUSIC C3#,-,-
	MUSIC -,-,-
	MUSIC D3#,-,-
	MUSIC -,-,-
	MUSIC D3#,-,-
	MUSIC -,-,-
	MUSIC D3#,-,-
	MUSIC C3#,-,-
	MUSIC C3#,-,-
	MUSIC C3#,-,-
	MUSIC -,-,-
	MUSIC D3#,-,-
	MUSIC -,-,-
	MUSIC D3#,-,-
	MUSIC C3#,-,-
	MUSIC C3#,-,-
	MUSIC -,-,-
	MUSIC D3#,-,-

	MUSIC F3#,-,-
	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
	MUSIC F3#,-,-
	MUSIC E3,-,-
	MUSIC E3,-,-
	MUSIC -,-,-
	MUSIC F3#,-,-
	MUSIC -,-,-
	MUSIC F3#,-,-
	MUSIC -,-,-
	MUSIC F3#,-,-
	MUSIC E3,-,-
	MUSIC E3,-,-
	MUSIC E3,-,-
	MUSIC -,-,-
	MUSIC F3#,-,-
	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
	MUSIC F3#,-,-
	MUSIC E3,-,-
	MUSIC E3,-,-
	MUSIC -,-,-
	MUSIC F3#,-,-
	MUSIC -,-,-

	MUSIC B3,-,-
	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
	MUSIC B3,-,-
	MUSIC A3,-,-
	MUSIC A3,-,-
	MUSIC -,-,-
	MUSIC F3#,-,-
	MUSIC -,-,-
	MUSIC F3#,-,-
	MUSIC -,-,-
	MUSIC F3#,-,-
	MUSIC E3,-,-
	MUSIC E3,-,-
	MUSIC E3,-,-
	MUSIC -,-,-
	MUSIC B2,-,-
	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
'	MUSIC -,-,-
	MUSIC B2,-,-
	MUSIC A2,-,-
	MUSIC A2,-,-
	MUSIC -,-,-
	MUSIC B2,-,-

	MUSIC STOP

music_title:
	DATA BYTE 8
	MUSIC C2Y,-,-
	MUSIC D2,-,-
	MUSIC E2,-,-
	MUSIC D2,-,-
	MUSIC C2,-,-
	MUSIC D2,-,-
	MUSIC E2,-,-
	MUSIC S,-,-
	MUSIC C2,-,-
	MUSIC S,-,-
	MUSIC C2,-,-
	MUSIC S,-,-
	MUSIC STOP

music_throw:
	DATA BYTE 3
	MUSIC G4#Z,-,-
	MUSIC S,-,-
	MUSIC C4,-,-
	MUSIC B4,-,-
	MUSIC S,-,-
	MUSIC S,-,-
	MUSIC S,-,-
	MUSIC A4#,-,-
	MUSIC STOP
